# Beaten Dying Moon Simple

This is a simple build of Beaten Dying Moon primarily intended for running test ROMs. 


## Usage

You MUST supply a Game Boy or Game Boy Color ROM file, either via the command line or by
dragging and dropping the ROM on top of the executable. There is no file selection
interface.

`bdms [options] rom_file.gb`

`-scale SCALE` Set the window scale, where SCALE is an integer value. Default is 3

`-soft` Use a software renderer

`-disable_high_dpi` Do not request a high DPI window from SDL

`-turbo` Run in turbo mode

`-ignore_boot_roms` Ignores any boot ROM files present in the directory of the executable

`-dmg` Emulates a device with `DMG-CPU C` SoC

`-cgb` Emulates a device with `CPU CGB E` SoC

`-dev SOC`
    
where SOC is one of: 
    
- `dmg0`
- `dmgA`
- `dmgB`
- `dmgC`
- `mgb`
- `sgb`
- `sgb2`
- `cgb0`
- `cgbA`
- `cgbB`
- `cgbC`
- `cgbD`
- `cgbE`
- `agb0`
- `pokemon_stadium_2`

On Windows, console output can be viewed by redirecting it to a file, e.g:

 ```
 bdms.exe test.gb > stdout.txt
 more stdout.txt
 ```


## Keyboard Input

<kbd>↑</kbd> = Up

<kbd>↓</kbd> = Down

<kbd>←</kbd> = Left

<kbd>→</kbd> = Right

<kbd>A</kbd> = B

<kbd>S</kbd> = A

<kbd>Shift</kbd> = Select

<kbd>Return</kbd> = Start

<kbd>Space</kbd> (held) = Fast-forward 

<kbd>W</kbd> = Write a .sym file with code, data and image blocks based on instructions executed during emulation. The file will be written to the same directory as the ROM, replacing the .gb/.gbc extension with .sym.

<kbd>Esc</kbd> or <kbd>Q</kbd> = Quit


## Boot ROMs
Boot ROMs can be added in the same directory as the executable. The following boot files will be detected automatically and used for the appropriate device:

- `dmg0_boot.bin`
- `dmg_boot.bin`
- `mgb_boot.bin`
- `sgb_boot.bin`
- `sgb2_boot.bin`
- `cgb0_boot.bin`
- `cgb_boot.bin`
- `agb_boot.bin`
- `pokemon_stadium_2_boot.bin`

If a boot ROM file is not found then the emulator will attempt to reproduce something similar to the machine state as it would be when execution reaches `$0100`.


## Website

[https://mattcurrie.com/bdm](https://mattcurrie.com/bdm)
